/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.logmonitor.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.noip.codebox.logmonitor.config.ILog;
import net.noip.codebox.logmonitor.config.IMonitor;
import net.noip.codebox.logmonitor.config.IOptions;
import net.noip.codebox.logmonitor.config.IStyle;
import net.noip.codebox.logmonitor.config.LogBean;
import net.noip.codebox.logmonitor.config.MonitorBean;
import net.noip.codebox.logmonitor.config.OptionsBean;
import net.noip.codebox.logmonitor.config.StyleBean;
import net.noip.codebox.logmonitor.target.AbstractMonitor;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFile {
    private static Logger logger = Logger.getLogger("net.noip.codebox.logmonitor.config.ConfigFile");
    private static final String COLOUR_PATTERN_TEXT = "#[0-9A-Fa-f]{6}";
    private static final Pattern COLOUR_PATTERN = Pattern.compile("#[0-9A-Fa-f]{6}");
    private Map<String, ILog> logMap = new LinkedHashMap();
    private Map<String, IMonitor> monitorMap = new HashMap();
    private Map<String, String> configMap = new HashMap();

    public ConfigFile(InputStream inputStream) throws IOException {
        Document document;
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            document = sAXBuilder.build(inputStream);
        }
        catch (JDOMException jDOMException) {
            throw new IllegalArgumentException("Unable to parse the configuration XML", jDOMException);
        }
        Element element = document.getRootElement();
        Element element2 = element.getChild("monitors");
        this.buildMonitorMap(element2);
        Element element3 = element.getChild("logs");
        this.buildLogMap(element3);
        Element element4 = element.getChild("configs");
        this.buildConfigMap(element4);
    }

    public Map<String, ILog> getLogMap() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Map<String, IMonitor> getMonitorMap() {
        return Collections.unmodifiableMap(this.monitorMap);
    }

    public Map<String, String> getConfigMap() {
        return Collections.unmodifiableMap(this.configMap);
    }

    private void buildMonitorMap(Element element) {
        assert (element.getName().equals("monitors")) : "Expected 'monitors' element";
        List list = element.getChildren("monitor");
        String string = null;
        String string2 = null;
        for (Object e : list) {
            try {
                Element element2 = (Element)e;
                assert (element2.getName().equals("monitor")) : "Expected a 'monitor' element";
                MonitorBean monitorBean = new MonitorBean();
                string2 = this.getRequiredAttributeValue(element2, "type");
                monitorBean.setName(string2);
                string = this.getRequiredAttributeValue(element2, "class");
                Class<?> clazz = Class.forName(string);
                if (AbstractMonitor.class.isAssignableFrom(clazz)) {
                    monitorBean.setClassObject(clazz);
                    this.monitorMap.put(string2, monitorBean);
                    continue;
                }
                logger.warning("The className found for monitor '" + string2 + "' was '" + clazz.getName() + "', which does not implement IMonitorable. Skipping this monitor.");
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.warning("Unable to find the class specified for monitor '" + string2 + "', the class was '" + string + "'.");
            }
            catch (Exception exception) {
                logger.warning("An unexpected exception occurred while attempting to process one of the 'monitor' elements  in the configuration file. The error was: " + exception.getMessage());
            }
        }
    }

    private void buildLogMap(Element element) {
        assert (element.getName().equals("logs")) : "Expected 'logs' element";
        List list = element.getChildren("log");
        for (Object e : list) {
            try {
                Element element2 = (Element)e;
                assert (element2.getName().equals("log")) : "Expected a 'log' element";
                LogBean logBean = new LogBean();
                String string = this.getRequiredAttributeValue(element2, "name");
                logBean.setName(string);
                logBean.setType(this.getRequiredAttributeValue(element2, "type"));
                logBean.setLocation(this.getRequiredAttributeValue(element2, "location"));
                logBean.setDefaultOptions(this.buildOptionsBean(element2));
                logBean.setDefaultStyles(this.buildStylesBean(element2));
                logBean.setFilter(this.buildFilter(element2));
                this.logMap.put(string, logBean);
            }
            catch (Exception exception) {
                logger.warning("An unexpected exception occurred while attempting to process one of the 'log' elements  in the configuration file. The error was: " + exception);
            }
        }
    }

    private void buildConfigMap(Element element) {
        assert (element.getName().equals("configs")) : "Expected 'configs' element";
        List list = element.getChildren("config");
        for (Object e : list) {
            try {
                Element element2 = (Element)e;
                assert (element2.getName().equals("config")) : "Expected a 'config' element";
                String string = this.getRequiredAttributeValue(element2, "name");
                String string2 = this.getRequiredAttributeValue(element2, "value");
                this.configMap.put(string, string2);
            }
            catch (Exception exception) {
                logger.warning("An unexpected exception occurred while attempting to process one of the 'config' elements  in the configuration file. The error was: " + exception);
            }
        }
    }

    private Pattern buildFilter(Element element) {
        assert (element.getName().equals("log")) : "Expected a 'log' element";
        Element element2 = element.getChild("filter");
        if (element2 != null) {
            String string = element2.getText();
            if (string != null && string.length() > 0) {
                try {
                    return Pattern.compile(string);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new IllegalArgumentException("Bad value for filter element - unable to compile a Pattern object from the String '" + string + "'");
                }
            }
            return null;
        }
        return null;
    }

    private IOptions buildOptionsBean(Element element) {
        assert (element.getName().equals("log")) : "Expected a 'log' element";
        Element element2 = element.getChild("options");
        if (element2 != null) {
            OptionsBean optionsBean = new OptionsBean();
            optionsBean.setInterval(this.getOptionalIntAttributeValue(element2, "interval"));
            optionsBean.setLines(this.getOptionalIntAttributeValue(element2, "lines"));
            optionsBean.setShowDividers(this.getOptionalBooleanAttributeValue(element2, "showDividers"));
            return optionsBean;
        }
        return null;
    }

    private List<IStyle> buildStylesBean(Element element) {
        assert (element.getName().equals("log")) : "Expected a 'log' element";
        Element element2 = element.getChild("styles");
        if (element2 != null) {
            ArrayList<IStyle> arrayList = new ArrayList<IStyle>();
            List list = element2.getChildren("style");
            for (Object e : list) {
                Element element3 = (Element)e;
                StyleBean styleBean = new StyleBean();
                styleBean.setBackColour(this.getOptionalColourAttributeValue(element3, "backColour"));
                styleBean.setForeColour(this.getOptionalColourAttributeValue(element3, "foreColour"));
                styleBean.setVisible(this.getOptionalBooleanAttributeValue(element3, "visible"));
                arrayList.add((IStyle)styleBean);
            }
            return arrayList;
        }
        return null;
    }

    private String getOptionalColourAttributeValue(Element element, String string) {
        assert (element != null) : "Expected non-null Element";
        String string2 = element.getAttributeValue(string);
        if (string2 == null) {
            return null;
        }
        if (COLOUR_PATTERN.matcher(string2).matches()) {
            return string2;
        }
        throw new IllegalArgumentException("Bad value for attribute '" + string + "', expected value matching regex '" + COLOUR_PATTERN_TEXT + "', but found '" + string2 + "'");
    }

    private Boolean getOptionalBooleanAttributeValue(Element element, String string) {
        assert (element != null) : "Expected non-null Element";
        String string2 = element.getAttributeValue(string);
        if ("true".equals(string2)) {
            return Boolean.TRUE;
        }
        if ("false".equals(string2)) {
            return Boolean.FALSE;
        }
        if (string2 == null) {
            return null;
        }
        throw new IllegalArgumentException("Bad value for attribute '" + string + "', expected 'true' or 'false' but found '" + string2 + "'");
    }

    private Integer getOptionalIntAttributeValue(Element element, String string) {
        assert (element != null) : "Expected non-null Element";
        String string2 = element.getAttributeValue(string);
        if (string2 == null) {
            return null;
        }
        try {
            return new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Bad value for attribute '" + string + "', expected a number but found '" + string2 + "'");
        }
    }

    private String getRequiredAttributeValue(Element element, String string) {
        assert (element != null) : "Expected non-null Element";
        String string2 = element.getAttributeValue(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Missing attribute: expected attribute '" + string + "' in element " + element.getName());
        }
        return string2;
    }
}

