/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder.util;

import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import net.noip.codebox.httpbuilder.HttpRequest;
import net.noip.codebox.httpbuilder.util.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final String REQ_CACHE_DIR = String.valueOf(Config.getApplicationDir()) + "request.cache" + File.separator;
    private static String base64chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    public static boolean comboContains(JComboBox comboBox, Object item) {
        return Utils.comboIndexOf(comboBox, item) >= 0;
    }

    public static int comboIndexOf(JComboBox comboBox, Object item) {
        int indexOfItem = -1;
        if (item != null) {
            ComboBoxModel model = comboBox.getModel();
            int i = 0;
            int l = model.getSize();
            while (i < l) {
                if (item.equals(model.getElementAt(i))) {
                    indexOfItem = i;
                    break;
                }
                ++i;
            }
        }
        return indexOfItem;
    }

    public static void clearRequests() {
        File[] files;
        File[] fileArray = files = Utils.getRequestFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    public static void saveRequests(List<HttpRequest> requests) throws IOException {
        Utils.clearRequests();
        int requestIndex = 0;
        for (HttpRequest request : requests) {
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(String.valueOf(REQ_CACHE_DIR) + "request." + requestIndex++ + ".ser"));
                out.writeObject(request);
                out.close();
            }
            catch (FileNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static File[] getRequestFiles() {
        File reqDir = new File(REQ_CACHE_DIR);
        if (!reqDir.exists()) {
            reqDir.mkdir();
        }
        return reqDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("request.") && name.endsWith(".ser");
            }
        });
    }

    public static List<HttpRequest> loadRequests() throws IOException {
        File[] files = Utils.getRequestFiles();
        ArrayList<HttpRequest> requests = new ArrayList<HttpRequest>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            try {
                requests.add((HttpRequest)in.readObject());
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
            in.close();
            ++n2;
        }
        return requests;
    }

    public static void showErrorMsg(String error) {
        JOptionPane.showMessageDialog(null, error, "Error", 0);
    }

    public static void positionDialogInParent(JDialog dialog, Frame parent) {
        int parentX = parent.getX();
        int parentY = parent.getY();
        dialog.setLocation(parentX + 100, parentY + 100);
    }

    public static String getMD5Hash(String value) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(value.getBytes());
            return Utils.bytesToHex(md5.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String bytesToHex(byte[] data) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        int l = data.length;
        while (i < l) {
            buf.append(Utils.byteToHex(data[i]));
            ++i;
        }
        return buf.toString();
    }

    private static String byteToHex(byte b) {
        int highHalf = (b & 0xFF) >>> 4;
        int lowHalf = b & 0xF;
        return String.valueOf(Utils.halfByteToChar(highHalf)) + Utils.halfByteToChar(lowHalf);
    }

    private static String halfByteToChar(int halfByteValue) {
        if (halfByteValue >= 0 && halfByteValue <= 9) {
            return "" + halfByteValue;
        }
        if (halfByteValue >= 10 && halfByteValue <= 16) {
            return "" + (char)(97 + halfByteValue - 10);
        }
        throw new AssertionError((Object)("Bad halfByteValue: " + halfByteValue));
    }

    public static String base64Encode(String text) {
        int mod3Result = text.length() % 3;
        int bytesToAppend = mod3Result == 0 ? 0 : 3 - mod3Result;
        int i = 0;
        while (i < bytesToAppend) {
            text = String.valueOf(text) + "\u0000";
            ++i;
        }
        byte[] stringAsBytes = text.getBytes();
        int resultArrayLength = 4 * stringAsBytes.length / 3;
        byte[] resultBytes = new byte[resultArrayLength];
        int i2 = 0;
        int l = stringAsBytes.length / 3;
        while (i2 < l) {
            int int1 = stringAsBytes[i2 * 3] & 0xFF;
            int int2 = stringAsBytes[i2 * 3 + 1] & 0xFF;
            int int3 = stringAsBytes[i2 * 3 + 2] & 0xFF;
            byte byte1 = (byte)(int1 >>> 2);
            byte byte2 = (byte)((int1 & 3) << 4 | int2 >>> 4);
            byte byte3 = (byte)((int2 & 0xF) << 2 | int3 >>> 6);
            byte byte4 = (byte)(int3 & 0x3F);
            resultBytes[i2 * 4] = byte1;
            resultBytes[i2 * 4 + 1] = byte2;
            resultBytes[i2 * 4 + 2] = byte3;
            resultBytes[i2 * 4 + 3] = byte4;
            ++i2;
        }
        String result = "";
        int lastNonPaddingByte = resultBytes.length - bytesToAppend - 1;
        int i3 = 0;
        while (i3 <= lastNonPaddingByte) {
            result = String.valueOf(result) + base64chars.charAt(resultBytes[i3]);
            ++i3;
        }
        i3 = 0;
        while (i3 < bytesToAppend) {
            result = String.valueOf(result) + "=";
            ++i3;
        }
        return result;
    }
}

