/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder.headerhelpers.panels;

import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DocumentFilter;
import net.noip.codebox.httpbuilder.headerhelpers.panels.IPanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.PanelChangeListener;

public class TextPanel
implements IPanel {
    private static final Dimension LABEL_SIZE = new Dimension(100, 20);
    private static final Dimension BOX_MAX_SIZE = new Dimension(1000, 20);
    private static final Dimension BOX_PREF_SIZE = new Dimension(100, 20);
    private JPanel panel;
    private JTextField txtField;
    private JLabel label;
    private String name;

    public TextPanel(String name) {
        this(name, false);
    }

    public TextPanel(String name, boolean isPassword) {
        this.name = name;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.add(Box.createRigidArea(new Dimension(10, 30)));
        this.label = new JLabel(name);
        this.label.setPreferredSize(LABEL_SIZE);
        this.label.setMaximumSize(LABEL_SIZE);
        this.panel.add(this.label);
        this.txtField = isPassword ? new JPasswordField() : new JTextField();
        this.txtField.setMaximumSize(BOX_MAX_SIZE);
        this.txtField.setPreferredSize(BOX_PREF_SIZE);
        this.panel.add(this.txtField);
        this.panel.add(Box.createHorizontalStrut(10));
    }

    public String getName() {
        return this.name;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public String getValue() {
        return this.txtField.getText();
    }

    public void setValue(String value) {
        this.txtField.setText(value);
    }

    public void setFilter(DocumentFilter filter) {
        ((AbstractDocument)this.txtField.getDocument()).setDocumentFilter(filter);
    }

    public void addChangeListener(final PanelChangeListener listener) {
        this.txtField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                listener.onChange(TextPanel.this);
            }
        });
    }

    public void setEnabled(boolean enabled) {
        this.txtField.setEnabled(enabled);
    }

    public void setData(Object data) {
        throw new UnsupportedOperationException("not done");
    }
}

