/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder.headerhelpers.panels;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import net.noip.codebox.httpbuilder.headerhelpers.NumericInputFilter;
import net.noip.codebox.httpbuilder.headerhelpers.panels.CheckboxPanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.IPanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.PanelChangeListener;
import net.noip.codebox.httpbuilder.headerhelpers.panels.TextPanel;

public class RangePanel
implements IPanel {
    private JPanel panel = new JPanel();
    private TextPanel fromBytePanel;
    private TextPanel toBytePanel;
    private CheckboxPanel bytesFromEndCheckboxPanel;
    private CheckboxPanel bytesToEndCheckboxPanel;
    private String name;

    public RangePanel(String name) {
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.add(this.makeByteFromPanel());
        this.panel.add(this.makeByteToPanel());
        this.panel.add(this.makeCheckboxFromEndPanel());
        this.panel.add(this.makeCheckboxToEndPanel());
    }

    private JPanel makeCheckboxFromEndPanel() {
        this.bytesFromEndCheckboxPanel = new CheckboxPanel("Bytes from end");
        this.bytesFromEndCheckboxPanel.addChangeListener(new PanelChangeListener(){

            public void onChange(IPanel panel) {
                RangePanel.this.fromBytePanel.setEnabled(CheckboxPanel.NOT_SELECTED_VALUE.equals(RangePanel.this.bytesFromEndCheckboxPanel.getValue()));
            }
        });
        return this.bytesFromEndCheckboxPanel.getPanel();
    }

    private JPanel makeCheckboxToEndPanel() {
        this.bytesToEndCheckboxPanel = new CheckboxPanel("Bytes to end");
        this.bytesToEndCheckboxPanel.addChangeListener(new PanelChangeListener(){

            public void onChange(IPanel panel) {
                RangePanel.this.toBytePanel.setEnabled(CheckboxPanel.NOT_SELECTED_VALUE.equals(RangePanel.this.bytesToEndCheckboxPanel.getValue()));
            }
        });
        return this.bytesToEndCheckboxPanel.getPanel();
    }

    private JPanel makeByteFromPanel() {
        this.fromBytePanel = new TextPanel("From Byte:");
        this.fromBytePanel.setFilter(new NumericInputFilter());
        return this.fromBytePanel.getPanel();
    }

    private JPanel makeByteToPanel() {
        this.toBytePanel = new TextPanel("To Byte:");
        this.toBytePanel.setFilter(new NumericInputFilter());
        return this.toBytePanel.getPanel();
    }

    public String getName() {
        return this.name;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public String getValue() {
        boolean isBytesToEnd = CheckboxPanel.SELECTED_VALUE.equals(this.bytesToEndCheckboxPanel.getValue());
        boolean isBytesFromEnd = CheckboxPanel.SELECTED_VALUE.equals(this.bytesFromEndCheckboxPanel.getValue());
        String value = "bytes=" + (isBytesFromEnd ? "" : this.fromBytePanel.getValue());
        value = String.valueOf(value) + "-";
        value = String.valueOf(value) + (isBytesToEnd ? "" : this.toBytePanel.getValue());
        return value;
    }

    public void setValue(String value) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void addChangeListener(final PanelChangeListener listener) {
        this.bytesToEndCheckboxPanel.addChangeListener(new PanelChangeListener(){

            public void onChange(IPanel panel) {
                listener.onChange(RangePanel.this);
            }
        });
        this.bytesFromEndCheckboxPanel.addChangeListener(new PanelChangeListener(){

            public void onChange(IPanel panel) {
                listener.onChange(RangePanel.this);
            }
        });
        this.toBytePanel.addChangeListener(new PanelChangeListener(){

            public void onChange(IPanel panel) {
                listener.onChange(RangePanel.this);
            }
        });
        this.fromBytePanel.addChangeListener(new PanelChangeListener(){

            public void onChange(IPanel panel) {
                listener.onChange(RangePanel.this);
            }
        });
    }

    public void setData(Object data) {
        throw new UnsupportedOperationException("not done");
    }

    public void setEnabled(boolean enabled) {
        this.bytesToEndCheckboxPanel.setEnabled(enabled);
        this.bytesFromEndCheckboxPanel.setEnabled(enabled);
        this.toBytePanel.setEnabled(enabled);
        this.fromBytePanel.setEnabled(enabled);
    }
}

