/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder.headerhelpers.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import net.noip.codebox.httpbuilder.headerhelpers.DateInputFilter;
import net.noip.codebox.httpbuilder.headerhelpers.TimeInputFilter;
import net.noip.codebox.httpbuilder.headerhelpers.panels.IPanel;
import net.noip.codebox.httpbuilder.headerhelpers.panels.PanelChangeListener;

public class DateTimePanel
implements IPanel {
    private static final Dimension BOX_INIT_SIZE = new Dimension(150, 20);
    private static final Dimension BOX_SIZE = new Dimension(1000, 20);
    private static final Dimension LABEL_SIZE = new Dimension(120, 20);
    static final String TIME_INPUT_FORMAT = "HH:mm:ss";
    private JPanel panel = new JPanel();
    private String name;
    private JTextField txtTimeField;
    static final String DATE_INPUT_FORMAT = "dd/MM/yyyy";
    static final SimpleDateFormat inputDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    static final String RFC1123_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    static final SimpleDateFormat outputDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
    private JTextField txtDateField;

    public DateTimePanel() {
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.add(this.makeDatePanel());
        this.panel.add(this.makeTimePanel());
    }

    private Component makeTimePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(10, 30)));
        JLabel label = new JLabel("Time [hh:mm:ss]");
        label.setPreferredSize(LABEL_SIZE);
        label.setMaximumSize(LABEL_SIZE);
        panel.add(label);
        this.txtTimeField = new JTextField(new SimpleDateFormat(TIME_INPUT_FORMAT).format(new Date()));
        ((AbstractDocument)this.txtTimeField.getDocument()).setDocumentFilter(new TimeInputFilter());
        panel.add(this.txtTimeField);
        this.txtTimeField.setPreferredSize(BOX_INIT_SIZE);
        this.txtTimeField.setMaximumSize(BOX_SIZE);
        panel.add(Box.createHorizontalStrut(10));
        return panel;
    }

    private Component makeDatePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(10, 30)));
        JLabel label = new JLabel("Date [dd/mm/yyyy]");
        label.setPreferredSize(LABEL_SIZE);
        label.setMaximumSize(LABEL_SIZE);
        panel.add(label);
        this.txtDateField = new JTextField(new SimpleDateFormat(DATE_INPUT_FORMAT).format(new Date()));
        ((AbstractDocument)this.txtDateField.getDocument()).setDocumentFilter(new DateInputFilter());
        panel.add(this.txtDateField);
        this.txtDateField.setPreferredSize(BOX_INIT_SIZE);
        this.txtDateField.setMaximumSize(BOX_SIZE);
        panel.add(Box.createHorizontalStrut(10));
        return panel;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public String getName() {
        throw new UnsupportedOperationException("not implemented");
    }

    public String getValue() {
        Date date = null;
        try {
            date = inputDateFormat.parse(String.valueOf(this.txtDateField.getText()) + " " + this.txtTimeField.getText());
            return outputDateFormat.format(date);
        }
        catch (ParseException e) {
            return "";
        }
    }

    public void setValue(String value) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void addChangeListener(final PanelChangeListener listener) {
        this.txtDateField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                listener.onChange(DateTimePanel.this);
            }
        });
        this.txtTimeField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                listener.onChange(DateTimePanel.this);
            }
        });
    }

    public void setEnabled(boolean enabled) {
        this.txtDateField.setEnabled(enabled);
        this.txtTimeField.setEnabled(enabled);
    }

    public void setData(Object data) {
        throw new UnsupportedOperationException("not done");
    }
}

