/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder.headerhelpers;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.noip.codebox.httpbuilder.headerhelpers.FieldBasedHeaderHelper;

public abstract class MultiValueFieldBasedHeaderHelper
extends FieldBasedHeaderHelper {
    protected List<String> valueList = new ArrayList<String>();
    protected String currentValue;

    protected void addExtras(JPanel mainPanel) {
        mainPanel.add(this.makeButtonPanel());
    }

    protected void customInit() {
        this.valueList.add("");
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.makeAddButton());
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.makeClearButton());
        return panel;
    }

    private JButton makeAddButton() {
        JButton button = new JButton("Add");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiValueFieldBasedHeaderHelper.this.valueList.add(MultiValueFieldBasedHeaderHelper.this.currentValue);
                MultiValueFieldBasedHeaderHelper.this.updateValue();
            }
        });
        return button;
    }

    private JButton makeClearButton() {
        JButton button = new JButton("Clear");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiValueFieldBasedHeaderHelper.this.valueList = new ArrayList<String>();
                MultiValueFieldBasedHeaderHelper.this.setValue("");
            }
        });
        return button;
    }

    protected void onFieldValueChanged() {
        this.currentValue = this.getCurrentValue();
    }

    protected void updateValue() {
        String valueString = "";
        for (String value : this.valueList) {
            if (valueString.length() > 0) {
                valueString = String.valueOf(valueString) + ", ";
            }
            valueString = String.valueOf(valueString) + value;
        }
        this.setValue(valueString);
    }
}

