/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder.headerhelpers;

import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.noip.codebox.httpbuilder.headerhelpers.HeaderHelperBase;
import net.noip.codebox.httpbuilder.util.Config;
import net.noip.codebox.httpbuilder.util.ConfigException;
import net.noip.codebox.httpbuilder.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListBasedHeaderHelper
extends HeaderHelperBase {
    protected JTextField txtValue;

    @Override
    protected void setupCustomGui(JPanel mainPanel) {
        mainPanel.add(this.makeCenterPanel());
        mainPanel.add(this.makeBottomPanel());
        mainPanel.add(Box.createVerticalStrut(10));
        this.setResizable(false);
        this.setSize(200, 300);
    }

    protected Map<String, String> getValues() {
        try {
            return Config.getValuesForHeader(this.getHeaderName());
        }
        catch (ConfigException e) {
            Utils.showErrorMsg(e.getMessage());
            return new HashMap<String, String>();
        }
    }

    @Override
    public String getTitle() {
        return String.valueOf(this.getHeaderName()) + " Header Helper";
    }

    protected abstract String getHeaderName();

    private Component makeCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        Map<String, String> items = this.getValues();
        for (Map.Entry<String, String> entry : items.entrySet()) {
            panel.add(this.makeComponent(entry.getKey(), entry.getValue()));
        }
        JScrollPane scrollableArea = new JScrollPane(panel);
        scrollableArea.setPreferredSize(new Dimension(300, 200));
        scrollableArea.setVerticalScrollBarPolicy(22);
        return scrollableArea;
    }

    protected abstract Component makeComponent(String var1, String var2);

    private JPanel makeBottomPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(WIDE_SPACER));
        this.txtValue = new JTextField(20);
        panel.add(this.txtValue);
        panel.add(Box.createRigidArea(WIDE_SPACER));
        return panel;
    }

    @Override
    protected String getValue() {
        return this.txtValue.getText();
    }
}

