/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder;

import net.noip.codebox.httpbuilder.util.Utils;
import org.junit.Assert;
import org.junit.Test;

public class UtilsTest {
    private static final String LONG_STRING = "Man is distinguished, not only by his reason, but by this singular passion from other animals, which is a lust of the mind, that by a perseverance of delight in the continued and indefatigable generation of knowledge, exceeds the short vehemence of any carnal pleasure.";
    private static final String GNARLY_STRING = "aAzZ09!\"\u00a3$%^&*()_-+=[{]};:'@#~,<.>/?\\|";

    @Test
    public void testEncoding() {
        Assert.assertEquals((Object)"", (Object)Utils.base64Encode(""));
        Assert.assertEquals((Object)"YQ==", (Object)Utils.base64Encode("a"));
        Assert.assertEquals((Object)"YWI=", (Object)Utils.base64Encode("ab"));
        Assert.assertEquals((Object)"YWJj", (Object)Utils.base64Encode("abc"));
        Assert.assertEquals((Object)"YmFzZTY0", (Object)Utils.base64Encode("base64"));
        Assert.assertEquals((Object)"QWxhZGRpbjpvcGVuIHNlc2FtZQ==", (Object)Utils.base64Encode("Aladdin:open sesame"));
        Assert.assertEquals((Object)"TWFuIGlzIGRpc3Rpbmd1aXNoZWQsIG5vdCBvbmx5IGJ5IGhpcyByZWFzb24sIGJ1dCBieSB0aGlzIHNpbmd1bGFyIHBhc3Npb24gZnJvbSBvdGhlciBhbmltYWxzLCB3aGljaCBpcyBhIGx1c3Qgb2YgdGhlIG1pbmQsIHRoYXQgYnkgYSBwZXJzZXZlcmFuY2Ugb2YgZGVsaWdodCBpbiB0aGUgY29udGludWVkIGFuZCBpbmRlZmF0aWdhYmxlIGdlbmVyYXRpb24gb2Yga25vd2xlZGdlLCBleGNlZWRzIHRoZSBzaG9ydCB2ZWhlbWVuY2Ugb2YgYW55IGNhcm5hbCBwbGVhc3VyZS4=", (Object)Utils.base64Encode(LONG_STRING));
        Assert.assertEquals((Object)"YUF6WjA5ISKjJCVeJiooKV8tKz1be119OzonQCN+LDwuPi8/XHw=", (Object)Utils.base64Encode(GNARLY_STRING));
    }

    @Test
    public void testMD5() {
        Assert.assertEquals((Object)"d41d8cd98f00b204e9800998ecf8427e", (Object)Utils.getMD5Hash(""));
        Assert.assertEquals((Object)"098f6bcd4621d373cade4e832627b4f6", (Object)Utils.getMD5Hash("test"));
        Assert.assertEquals((Object)"41fd7501e545f64ff38592052230efd3", (Object)Utils.getMD5Hash(GNARLY_STRING));
        Assert.assertEquals((Object)"cc5bf212320bfb562bf7111ab0ab4bf9", (Object)Utils.getMD5Hash(LONG_STRING));
    }
}

