/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder;

import net.noip.codebox.httpbuilder.HttpUrl;
import org.junit.Assert;
import org.junit.Test;

public class HttpUrlTest {
    @Test
    public void testProtocol() {
        HttpUrl url = new HttpUrl("test.com");
        Assert.assertEquals((Object)"http", (Object)url.getProtocol());
        url = new HttpUrl("http://test.com");
        Assert.assertEquals((Object)"http", (Object)url.getProtocol());
        url = new HttpUrl("HtTp://test.com");
        Assert.assertEquals((Object)"HtTp", (Object)url.getProtocol());
        this.checkBadUrl("bad://test.com");
        this.checkBadUrl("://test.com");
    }

    @Test
    public void testHost() {
        this.checkBadUrl("");
        String HOST_255_CHARS = "123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.12345";
        String HOST_256_CHARS = "123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456";
        this.checkOkHost("123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.12345");
        this.checkBadUrl("123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456");
        String HOST_PART_63_CHARS = "123456789012345678901234567890123456789012345678901234567890123";
        String HOST_PART_64_CHARS = "1234567890123456789012345678901234567890123456789012345678901234";
        String hostWithTwoLongButLegalParts = "123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123";
        this.checkOkHost(hostWithTwoLongButLegalParts);
        String hostWithOnePartTooLong = "123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234";
        this.checkBadUrl(hostWithOnePartTooLong);
        String hostWithZeroLengthPart = "123.123..123";
        this.checkBadUrl(hostWithZeroLengthPart);
        String hostWithAllLegalChars = "abcdefghijkl-mnopqrstuvwxyz.0123456789";
        this.checkOkHost(hostWithAllLegalChars);
        String hostWithIllegalChars = "abcdefghijkl%asd*asd9";
        this.checkBadUrl(hostWithIllegalChars);
        String hostStartsWithHyphen = "-abcd";
        this.checkBadUrl(hostStartsWithHyphen);
        String hostEndsWithHyphen = "abcd-";
        this.checkBadUrl(hostEndsWithHyphen);
        String hostPartStartsWithHyphen = "abcd.-efg";
        this.checkBadUrl(hostPartStartsWithHyphen);
        String hostPartEndsWithHyphen = "abcd-.efg";
        this.checkBadUrl(hostPartEndsWithHyphen);
    }

    private void checkOkHost(String host) {
        HttpUrl url = new HttpUrl(host);
        Assert.assertEquals((Object)host, (Object)url.getHost());
    }

    @Test
    public void testPort() {
        this.checkOkPort("http://host.com", 80);
        this.checkOkPort("http://host.com/", 80);
        this.checkOkPort("http://host.com/path.here", 80);
        this.checkOkPort("http://host.com:8080", 8080);
        this.checkOkPort("http://host.com:8080/", 8080);
        this.checkOkPort("http://host.com:8080/path.here", 8080);
        this.checkBadUrl("http://host.com:");
        this.checkBadUrl("http://host.com:/");
        this.checkBadUrl("http://host.com:/path.here");
        this.checkBadUrl("http://host.com:a");
        this.checkBadUrl("http://host.com: /");
        this.checkBadUrl("http://host.com:12x4/path.here");
        this.checkBadUrl("http://host.com:0");
        this.checkOkPort("http://host.com:1", 1);
        this.checkOkPort("http://host.com:65535", 65535);
        this.checkBadUrl("http://host.com:65536");
    }

    private void checkOkPort(String urlText, int port) {
        HttpUrl url = new HttpUrl(urlText);
        Assert.assertEquals((Object)port, (Object)url.getPort());
    }

    @Test
    public void testPath() {
        this.checkOkPath("http://host.com", "");
        this.checkOkPath("http://host.com/", "");
        this.checkOkPath("http://host.com/a", "a");
        this.checkOkPath("http://host.com/a/b/c", "a/b/c");
        this.checkOkPath("http://host.com/a/b/c?d/e", "a/b/c");
        String WORST_PATH_EVER = "aAzZ09$-_.+!*'(),;:&@=";
        this.checkOkPath("http://host.com/aAzZ09$-_.+!*'(),;:&@=?abc", "aAzZ09$-_.+!*'(),;:&@=");
        this.checkOkPath("http://host.com/%01", "%01");
        this.checkOkPath("http://host.com/%aF", "%aF");
        this.checkOkPath("http://host.com/%20%A0%1f", "%20%A0%1f");
        this.checkBadUrl("http://host.com/%aG");
        this.checkBadUrl("http://host.com?a");
        this.checkBadUrl("http://host.com/\\");
    }

    private void checkOkPath(String urlText, String path) {
        HttpUrl url = new HttpUrl(urlText);
        Assert.assertEquals((Object)path, (Object)url.getPath());
    }

    @Test
    public void testQueryString() {
        this.checkOkQueryString("http://host.com", "");
        this.checkOkQueryString("http://host.com/", "");
        this.checkOkQueryString("http://host.com/?", "");
        this.checkOkQueryString("http://host.com/?x", "x");
        this.checkOkQueryString("http://host.com/a", "");
        this.checkOkQueryString("http://host.com/a?", "");
        this.checkOkQueryString("http://host.com/a?b", "b");
        this.checkOkQueryString("http://host.com/a/b?c/d", "c/d");
        String QRY_STR_EVER = "aAzZ09$-_.+!*'(),;:&@=";
        this.checkOkQueryString("http://host.com/a?aAzZ09$-_.+!*'(),;:&@=", "aAzZ09$-_.+!*'(),;:&@=");
        this.checkOkQueryString("http://host.com/?%01", "%01");
        this.checkOkQueryString("http://host.com/?%aF", "%aF");
        this.checkOkQueryString("http://host.com/?%20%A0%1f", "%20%A0%1f");
        this.checkBadUrl("http://host.com/?%aG");
        this.checkBadUrl("http://host.com/a?b?c");
        this.checkBadUrl("http://host.com/?\\");
    }

    private void checkOkQueryString(String urlText, String queryString) {
        HttpUrl url = new HttpUrl(urlText);
        Assert.assertEquals((Object)queryString, (Object)url.getQueryString());
    }

    @Test
    public void testUrlFormatting() {
        this.checkUrlFormatting("HTtP://test.com", "http://test.com");
        this.checkUrlFormatting("test.com", "http://test.com");
        this.checkUrlFormatting("http://TeSt.cOm", "http://test.com");
        this.checkUrlFormatting("http://test.com:80", "http://test.com");
        this.checkUrlFormatting("http://test.com:123", "http://test.com:123");
        this.checkUrlFormatting("http://test.com:80/Path", "http://test.com/Path");
        this.checkUrlFormatting("http://test.com/PaTh?qUeRy", "http://test.com/PaTh?qUeRy");
        this.checkUrlFormatting("http://test.com/?qUeRy", "http://test.com/?qUeRy");
    }

    private void checkUrlFormatting(String unformatted, String formatted) {
        HttpUrl url = new HttpUrl(unformatted);
        Assert.assertEquals((Object)formatted, (Object)url.getFormattedUrl());
    }

    private void checkBadUrl(String url) {
        try {
            new HttpUrl(url);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

