/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder;

import java.io.Serializable;
import java.util.regex.Pattern;

public class HttpUrl
implements Serializable {
    private String protocol;
    private String host;
    private int port;
    private String path;
    private String queryString;
    private String formattedUrl;
    private static final String PROTOCOL_SEPARATOR = "://";
    private static final String PROTOCOL_HTTP = "http";
    private static final int MIN_PORT = 1;
    private static final int MAX_PORT = 65535;
    static final String PATH_PATTERN_TEXT = "([A-Za-z0-9\\$\\-_\\.\\+!\\*'\\(\\),;:@&=\\/]|%[a-fA-F0-9][a-fA-F0-9])*";
    static final Pattern PATH_PATTERN = Pattern.compile("([A-Za-z0-9\\$\\-_\\.\\+!\\*'\\(\\),;:@&=\\/]|%[a-fA-F0-9][a-fA-F0-9])*");
    static final String HOST_COMPONENT_PATTERN_TEXT = "[0-9a-z\\-]+";
    static final Pattern HOST_COMPONENT_PATTERN = Pattern.compile("[0-9a-z\\-]+");

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HttpUrl) {
            HttpUrl other = (HttpUrl)obj;
            boolean isEqual = (other.protocol == null ? this.protocol == null : other.protocol.equals(this.protocol)) && (other.host == null ? this.host == null : other.host.equals(this.host)) && (other.path == null ? this.path == null : other.path.equals(this.path)) && (other.queryString == null ? this.queryString == null : other.queryString.equals(this.queryString)) && (other.formattedUrl == null ? this.formattedUrl == null : other.formattedUrl.equals(this.formattedUrl)) && other.port == this.port;
            return isEqual;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 37 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 37 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 37 * result + (this.queryString == null ? 0 : this.queryString.hashCode());
        result = 37 * result + (this.formattedUrl == null ? 0 : this.formattedUrl.hashCode());
        result = 37 * result + this.port;
        return result;
    }

    public String toString() {
        return this.getFormattedUrl();
    }

    public HttpUrl(String urlText) throws IllegalArgumentException {
        String portText;
        String urlWithoutProtocol;
        String trimmedUrlText = urlText.trim();
        int protocolSeparatorIndex = trimmedUrlText.indexOf(PROTOCOL_SEPARATOR);
        if (protocolSeparatorIndex == -1) {
            this.protocol = PROTOCOL_HTTP;
            urlWithoutProtocol = trimmedUrlText;
        } else {
            this.protocol = trimmedUrlText.substring(0, protocolSeparatorIndex);
            urlWithoutProtocol = trimmedUrlText.substring(protocolSeparatorIndex + PROTOCOL_SEPARATOR.length());
        }
        this.checkProtocol(this.protocol);
        String[] urlParts = urlWithoutProtocol.split("/", 2);
        String hostWithPort = urlParts[0].toLowerCase();
        String[] hostParts = hostWithPort.split(":", 2);
        if (hostParts.length > 1) {
            this.host = hostParts[0];
            portText = hostParts[1];
        } else {
            this.host = hostWithPort;
            portText = this.getPortForProtocol(this.protocol);
        }
        this.checkHost(this.host);
        this.port = this.checkPortAndConvert(portText);
        String pathAndQueryString = urlParts.length > 1 ? urlParts[1] : "";
        String[] pathParts = pathAndQueryString.split("\\?", 2);
        if (pathParts.length > 1) {
            this.path = pathParts[0];
            this.queryString = pathParts[1];
        } else {
            this.path = pathParts[0];
            this.queryString = "";
        }
        this.checkPath(this.path);
        this.checkQueryString(this.queryString);
        this.formattedUrl = String.valueOf(this.getProtocol().toLowerCase()) + PROTOCOL_SEPARATOR + this.getHost().toLowerCase();
        if (!this.isDefaultPortForProtocol(this.getProtocol(), this.getPort())) {
            this.formattedUrl = String.valueOf(this.formattedUrl) + ":" + this.getPort();
        }
        if (this.getPath().length() > 0) {
            this.formattedUrl = String.valueOf(this.formattedUrl) + "/" + this.getPath();
            if (this.getQueryString().length() > 0) {
                this.formattedUrl = String.valueOf(this.formattedUrl) + "?" + this.getQueryString();
            }
        } else if (this.getQueryString().length() > 0) {
            this.formattedUrl = String.valueOf(this.formattedUrl) + "/?" + this.getQueryString();
        }
    }

    private String getPortForProtocol(String protocol) {
        if (PROTOCOL_HTTP.equalsIgnoreCase(protocol)) {
            return "80";
        }
        throw new AssertionError((Object)("Unexpected protocol value of '" + protocol + "'"));
    }

    private boolean isDefaultPortForProtocol(String protocol, int port) {
        return this.getPortForProtocol(protocol).equals("" + port);
    }

    private int checkPortAndConvert(String port) {
        try {
            int portNumber = Integer.parseInt(port);
            if (portNumber < 1) {
                throw new IllegalArgumentException("Bad port number, must be at least 1");
            }
            if (portNumber > 65535) {
                throw new IllegalArgumentException("Bad port number, must be at most 65535");
            }
            return portNumber;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Bad port number, must contain numeric characters only: '" + port + "'", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPath(String path) {
        Pattern pattern = PATH_PATTERN;
        synchronized (pattern) {
            if (!PATH_PATTERN.matcher(path).matches()) {
                throw new IllegalArgumentException("Path contains invalid characters - must match the regular expression: ([A-Za-z0-9\\$\\-_\\.\\+!\\*'\\(\\),;:@&=\\/]|%[a-fA-F0-9][a-fA-F0-9])*");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkQueryString(String queryString) {
        Pattern pattern = PATH_PATTERN;
        synchronized (pattern) {
            if (!PATH_PATTERN.matcher(queryString).matches()) {
                throw new IllegalArgumentException("Query String contains invalid characters - must match the regular expression: ([A-Za-z0-9\\$\\-_\\.\\+!\\*'\\(\\),;:@&=\\/]|%[a-fA-F0-9][a-fA-F0-9])*");
            }
        }
    }

    private void checkHost(String host) {
        String[] labels;
        boolean MIN_HOST_LEN = true;
        int MAX_HOST_LEN = 255;
        int hostLength = host.length();
        if (hostLength < 1) {
            throw new IllegalArgumentException("Host name is too short - must contain 1 or more characters");
        }
        if (hostLength > 255) {
            throw new IllegalArgumentException("Host name is too long - must contain 255 or fewer characters");
        }
        String[] stringArray = labels = host.split("\\.");
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            this.checkLabel(label);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLabel(String label) {
        boolean MIN_LABEL_LENGTH = true;
        int MAX_LABEL_LENGTH = 63;
        int labelLength = label.length();
        if (labelLength < 1) {
            throw new IllegalArgumentException("Host name is invalid - dots must be separated by 1 or more characters");
        }
        if (labelLength > 63) {
            throw new IllegalArgumentException("Host name is invalid - no more than 63 consecutive characters may appear without a dot delimiter");
        }
        Pattern pattern = HOST_COMPONENT_PATTERN;
        synchronized (pattern) {
            if (!HOST_COMPONENT_PATTERN.matcher(label).matches()) {
                throw new IllegalArgumentException("Host name contains invalid characters, only alphanumerics, hyphens and dots are allowed.");
            }
        }
        if (label.startsWith("-") || label.endsWith("-")) {
            throw new IllegalArgumentException("Host name is invalid - cannot start or end with a hyphen, nor can a hypen immediately precede or follow a dot");
        }
    }

    private void checkProtocol(String protocol) {
        if (!PROTOCOL_HTTP.equals(protocol.toLowerCase())) {
            throw new IllegalArgumentException("Invalid protocol: '" + protocol + "'");
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getPathWithQueryString() {
        return String.valueOf(this.getPath()) + (this.getQueryString().length() > 0 ? "?" + this.getQueryString() : "");
    }

    public String getFormattedUrl() {
        return this.formattedUrl;
    }
}

