/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.httpbuilder;

import java.util.ArrayList;
import net.noip.codebox.httpbuilder.HttpRequest;
import net.noip.codebox.httpbuilder.HttpUrl;
import net.noip.codebox.httpbuilder.ProxyConfig;
import org.junit.Assert;
import org.junit.Test;

public class HttpRequestTest {
    @Test
    public void testAccessors() {
        HttpRequest.Method METHOD = HttpRequest.Method.HEAD;
        HttpRequest.HttpVersion VERSION = HttpRequest.HttpVersion.V1_1;
        HttpUrl URL2 = new HttpUrl("urltext");
        HttpRequest req = new HttpRequest(METHOD, URL2, VERSION, new ArrayList<HttpRequest.HeaderValue>());
        Assert.assertEquals((Object)((Object)METHOD), (Object)((Object)req.getMethod()));
        Assert.assertEquals((Object)((Object)VERSION), (Object)((Object)req.getHttpVersion()));
        Assert.assertEquals((Object)URL2, (Object)req.getUrl());
    }

    @Test
    public void testGetRequestText() {
        HttpRequest.Method METHOD = HttpRequest.Method.GET;
        HttpRequest.HttpVersion VERSION = HttpRequest.HttpVersion.V1_0;
        String URL_PART1 = "http://www.google.co.uk";
        String URL_PART2 = "/mypage?x=123";
        HttpUrl URL2 = new HttpUrl(String.valueOf(URL_PART1) + URL_PART2);
        ProxyConfig PROXY_CONFIG1 = new ProxyConfig(false, null, 0, null, null);
        HttpRequest req1 = new HttpRequest(METHOD, URL2, VERSION, new ArrayList<HttpRequest.HeaderValue>());
        String result1 = req1.getRequestText(PROXY_CONFIG1);
        Assert.assertEquals((Object)(String.valueOf(METHOD.toString()) + " " + URL_PART2 + " " + VERSION.toString() + "\r\n\r\n"), (Object)result1);
        ProxyConfig PROXY_CONFIG2 = new ProxyConfig(true, "somehost", 123, "user", "pass");
        HttpRequest req2 = new HttpRequest(METHOD, URL2, VERSION, new ArrayList<HttpRequest.HeaderValue>());
        String result2 = req2.getRequestText(PROXY_CONFIG2);
        Assert.assertEquals((Object)(String.valueOf(METHOD.toString()) + " " + URL_PART1 + URL_PART2 + " " + VERSION.toString() + "\r\n\r\n"), (Object)result2);
    }
}

