<?xml version="1.0"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:template match="/">
		<html>
			<head>
				<title>DirView Report</title>
				<style>
				    body{
				        font-family: sans-serif;
				    }
				    h1{
				        text-align: center;
				        font-size: 1.5em;
				        font-weight: normal;
				    }
				    th, td{
				    	border: 1px solid black;
				    }
				    th{
				    	background-color: green;
				    	text-align: left;
				    	font-weight: normal;
				    	color: white;
				    	padding-left: 0.5em;
				    }
				    table{
				    	width: 95%;
				    	padding-bottom: 2em;
				    }
				    td.colheader{
				    	font-weight: bold;
				    }
				</style>
			</head>
			<body>
			    <h1>DirView Report for <xsl:value-of select="/dir/@path"/></h1>
   				<xsl:for-each select="//dir">
   					<table>
	   					<tr>
	   						<th colspan="3">Path: <xsl:value-of select="@path"/></th>
	   					</tr>
	   					<xsl:if test="count(file)=0">
		   					<tr>
		   						<td><i>Empty</i></td>
		   					</tr>
	   					</xsl:if>
	   					<xsl:if test="count(file)>0">
					        <tr>
					            <td class="colheader">File</td>
					            <td class="colheader">Size</td>
					            <td class="colheader">Modification Time</td>
					        </tr>
					        <xsl:for-each select="file">
			   					<tr>
			   			            <td><xsl:value-of select="@name"/></td>
			   			            <td><xsl:value-of select="@formattedSize"/></td>
			   			            <td><xsl:value-of select="@formattedModTime"/></td>
			   			        </tr>
					        </xsl:for-each>
				        </xsl:if>
   			        </table>
   				</xsl:for-each>			        
				<small>This report was generated by <a href="http://codebox.no-ip.net/controller?page=dirview">DirView</a></small>   				
			</body>
		</html>
    </xsl:template>
</xsl:transform>