/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.dirview;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.noip.codebox.dirview.FileSystemItem;
import net.noip.codebox.dirview.Utils;
import org.jdom.Element;

public class FileBean
implements FileSystemItem {
    private String fileName;
    private String location;
    private String fullPath;
    private String jsonSafeFullPath;
    private String sizeFormatted;
    private String dateFormatted;
    private String jsonSafeName;
    private long size;
    private long modTime;
    private final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private final long BYTES_PER_K = 1024L;
    private final long BYTES_PER_M = 0x100000L;
    private final long BYTES_PER_G = 0x40000000L;
    private NumberFormat NUM_FORMAT = new DecimalFormat("0.00");
    static final String FILE_ELEMENT = "file";
    static final String FILE_NAME_ATTRIB = "name";
    static final String FILE_NAME_JSON_SAFE_ATTRIB = "jsonSafeName";
    static final String FILE_PATH_ATTRIB = "path";
    static final String FILE_PATH_JSON_SAFE_ATTRIB = "jsonSafePath";
    static final String FILE_SIZE_ATTRIB = "size";
    static final String FILE_SIZEFMT_ATTRIB = "formattedSize";
    static final String FILE_MODTIME_ATTRIB = "modTime";
    static final String FILE_MODTIMEFMT_ATTRIB = "formattedModTime";

    public FileBean(String fileName, String location, String fullPath, long size, long modTime) {
        this.fileName = fileName;
        this.location = location;
        this.fullPath = fullPath;
        this.size = size;
        this.modTime = modTime;
        this.sizeFormatted = this.formatSize(size);
        this.dateFormatted = this.formatDate(modTime);
        this.jsonSafeName = Utils.formatForJson(fileName);
        this.jsonSafeFullPath = Utils.formatForJson(fullPath);
    }

    private String formatDate(long modTime) {
        return this.DATE_FORMAT.format(new Date(modTime));
    }

    private String formatSize(long size) {
        String amount;
        String units;
        if (size < 1024L) {
            units = "bytes";
            amount = "" + size;
        } else if (size < 0x100000L) {
            units = "kB";
            amount = this.NUM_FORMAT.format((double)size / 1024.0);
        } else if (size < 0x40000000L) {
            units = "MB";
            amount = this.NUM_FORMAT.format((double)size / 1048576.0);
        } else {
            units = "GB";
            amount = this.NUM_FORMAT.format((double)size / 1.073741824E9);
        }
        return String.valueOf(amount) + " " + units;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public long getSize() {
        return this.size;
    }

    public long getModTime() {
        return this.modTime;
    }

    public String toString() {
        return "FILE: " + this.location + System.getProperty("file.separator") + this.fileName;
    }

    public Element toElement() {
        Element element = new Element(FILE_ELEMENT);
        element.setAttribute(FILE_NAME_ATTRIB, this.getFileName());
        element.setAttribute(FILE_NAME_JSON_SAFE_ATTRIB, this.getJsonSafeName());
        element.setAttribute(FILE_PATH_ATTRIB, this.getFullPath());
        element.setAttribute(FILE_PATH_JSON_SAFE_ATTRIB, this.getJsonSafeFullPath());
        element.setAttribute(FILE_SIZE_ATTRIB, "" + this.getSize());
        element.setAttribute(FILE_SIZEFMT_ATTRIB, this.getSizeFormatted());
        element.setAttribute(FILE_MODTIME_ATTRIB, "" + this.getModTime());
        element.setAttribute(FILE_MODTIMEFMT_ATTRIB, this.getDateFormatted());
        return element;
    }

    public String getSizeFormatted() {
        return this.sizeFormatted;
    }

    public String getDateFormatted() {
        return this.dateFormatted;
    }

    public String getJsonSafeName() {
        return this.jsonSafeName;
    }

    public String getJsonSafeFullPath() {
        return this.jsonSafeFullPath;
    }
}

