/*
 * Decompiled with CFR 0.152.
 */
package net.noip.codebox.dirview;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.noip.codebox.dirview.FileBean;
import net.noip.codebox.dirview.FileSystemItem;
import net.noip.codebox.dirview.Utils;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirBean
implements FileSystemItem {
    private String path;
    private String jsonSafePath;
    private List<FileSystemItem> contents = new ArrayList<FileSystemItem>();
    private OutputStream out = this.out;
    private static final String DIR_ELEMENT = "dir";
    private static final String DIR_PATH_ATTRIB = "path";
    private static final String DIR_PATH_JSON_SAFE_ATTRIB = "jsonSafePath";

    public DirBean(File dir) throws IOException {
        this.print("Processing " + dir.getAbsolutePath());
        File[] listing = dir.listFiles();
        this.path = dir.getCanonicalPath().replace('\\', '/');
        this.jsonSafePath = Utils.formatForJson(this.path);
        if (listing != null) {
            File[] fileArray = listing;
            int n = listing.length;
            int n2 = 0;
            while (n2 < n) {
                File item = fileArray[n2];
                if (item.isFile()) {
                    this.contents.add(new FileBean(item.getName(), item.getParentFile().getPath(), item.getAbsolutePath(), item.length(), item.lastModified()));
                } else {
                    this.contents.add(new DirBean(item));
                }
                ++n2;
            }
        }
    }

    private void print(String msg) {
        Utils.printMsg(msg);
    }

    public String getPath() {
        return this.path;
    }

    public String getJsonSafePath() {
        return this.jsonSafePath;
    }

    public List<FileSystemItem> getContents() {
        return this.contents;
    }

    @Override
    public Element toElement() {
        Element element = new Element(DIR_ELEMENT);
        element.setAttribute(DIR_PATH_ATTRIB, this.getPath());
        element.setAttribute(DIR_PATH_JSON_SAFE_ATTRIB, this.getJsonSafePath());
        for (FileSystemItem item : this.getContents()) {
            element.addContent(item.toElement());
        }
        return element;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("DIR: " + this.path + "\n");
        for (FileSystemItem item : this.contents) {
            String thisValue = item.toString();
            result.append(String.valueOf(thisValue) + (item.toString().endsWith("\n") ? "" : "\n"));
        }
        return result.toString();
    }
}

